/* LCM.h -- wqLCD ҲխnΨ쪺 */
/*
V3.3/V4.2
4=P3.2=RS
5=P3.1=R/W
6=P3.0=EN
V3.3A/V4.2A
4=P3.6=RS
5=P3.5=R/W
6=P3.4=EN
#define LCDP P0	 // wqLCM ƶ׬yƱP0

sbit RS = P3^7;	 // Ȧsܦ줸(0:O,1:)
sbit RW = P3^6;	 // ]wŪg줸 (0:gJ,1:Ū)
sbit E =  P3^5;	 // P줸 (0:T,1:P)
#define LCDP P2	 // wqLCM ƶ׬yƱP2
*/
//#define LCDP P2	 // wqLCM ƶ׬yƱP2
#define LCDP P0	 // wqLCM ƶ׬yƱP2
sbit RS = P3^2;	 // Ȧsܦ줸(0:O,1:)
sbit RW = P3^1;	 // ]wŪg줸 (0:gJ,1:Ū)
sbit E =  P3^0;	 // P줸 (0:T,1:P)
//sbit BF = P2^7;	 // Lˬd줸(0:,1:L)
sbit BF = P0^7;	 // Lˬd줸(0:,1:L)
//====  ================================
void delay1ms(int x)
{	int i,j;					// ŧiܼ 
	for (i=1;i<x;i++)			// x,X*1ms
		for (j=1;j<120;j++);	// 120,1ms
}								// delay1ms()Ƶ 
//==== ˬdL ================================
void check_BF(void)
{	E=0;						// TŪgʧ@ 
	do							// do-whilej}l 
	{ 	BF=1;					// ]wBFJ 
	  	RS = 0; RW = 1;E = 1; 	// ŪBFAC
	}while(BF == 1);			// L~ 
}								// check_BF()Ƶ 
//==== gJO ================================
void write_inst(char inst)
{	check_BF();		      		// ˬdO_L 
	LCDP = inst;				// LCMŪJMPUO 
	RS = 0; RW = 0; E = 1;		// gJOLCM
	check_BF();		      		// ˬdO_L 
}				       			// write_inst()Ƶ 
//==== gJrƨ ============================
void write_char(char chardata)
{	check_BF();					// ˬdO_L 
	LCDP = chardata;			// LCMŪJr  
	RS = 1; RW = 0 ;E = 1;		// gJƦLCM
	check_BF();					// ˬdO_L 
}								// write_char()Ƶ 	 
//==== gJr ================================
void write_str(bit row,char *str,int time)
{	unsigned char i,j,addr;	  	// ŧiܼ 
	addr = (row==0)? 0x80:0x90;	// pXrC} 
	write_inst(addr);		  	// wrC} 
	for(i=0;i<32;i++)		  	// M@C  
		write_char(0x20);   	// Jť 
	write_inst(addr);		  	// wrC} 
	for(i=0;str[i] != '\0';i++) // ij,gJrܵ 
	{	if(i>=18 && i%2==0)		// WXܽd 
			write_inst(0x18);	// V1Ӥr 
		write_char(str[i]);   	// gJrꤺe	
	 	delay1ms(time);	  		// time*1ms
	}				 			// ij鵲	
	for(j=0;j<(i-18);j+=2)		// ij,ޭ^ 
	{	delay1ms(time);	  		// time*1ms
		write_inst(0x1C);		// Vk1Ӥr 
	}							// jj鵲	
	write_inst(0x02);			// k  
}					  			// write_str()Ƶ 
//==== gJϧΨ ================================
void write_bmp()
{	int i,j;					// ŧiܼ 
	write_inst(0x36);			// ]wXRO 
	for(i=0;i<Height;i++)		// ij,HeightϰC 
	{	write_inst(0x80+(31-i));// ]wGDRAMYb 
		write_inst(0x80);		// ]wGDRAMXb 
		for(j=0;j<32;j++)		// jj,ϳ̤j32B=256b
		  if(j<Width)			// pϼe Byte 
		    write_char(~BMPpic[Width*i+j]); // gJϧΤe 			
		  else					// WXϼe 
		    write_char(0x00);	// gJť 	
	}							// ij鵲 	
}								// write_bmp()Ƶ 
//== ѥRr =============================== 
void LDEL_str(bit row,int time)
{	unsigned char i,addr;		// ŧiܼ 
	addr = (row==0)? 0x80:0x90;	// pXrC} 
	write_inst(addr);			// wrgJC_l} 
	for(i=0;i<16;i++)			// M@C(16Ӥ)
	{	write_char(0x20);		// Jť 
		write_char(0x20);		// Jť 
		if(i<9)					// bܽd 
		  delay1ms(time);		// ɶ 
	}							// for  
}								// LDEL_str()Ƶ 
// == {{ == TG(0:r,1:ϧ)=======================================
void flash(bit TG,char count,int time)
{	char i;						// ŧiܼ 
	for(i=0;i<count;i++)		// {{3 
	{	if(TG == 0)				// r 
			write_inst(0x08);	// ܹ 
		else					// ϧΤ 
			write_inst(0x34);	// ܹ 
		delay1ms(time);			// time*1ms
		if(TG == 0)				// r 
			write_inst(0x0C); 	// }ܹ 
		else					// ϧΤ 
			write_inst(0x36); 	// }ܹ 
		delay1ms(time);			// time*1ms
	}							// forj鵲		
}								// flash()Ƶ 
// === r ========================================
void rotate_left(int count,int time)
{	unsigned i;					// ŧiܼ 
	write_inst(0x30);			// ]^򥻫O 
	for(i=0;i<count;i++)		// V16 	
	{	write_inst(0x18);		// V1Ӥr 
		delay1ms(time);			// time*1ms
	}							// ij鵲 
}								// rotate()Ƶ 
// === ϥթ٭==========================================
void reverse(bit row)
{ 	write_inst(0x34);			// ]wXRO 
	if (row==0)					// 0C 
		write_inst(0x04);		// ϥթ٭,0C 
	else						// 1C  
		write_inst(0x05); 		// ϥթ٭,1C 
	write_inst(0x30);			// ]^򥻫O 
}								// reverse()Ƶ 
//====l]w(8줸ǿҦ)===================
void init_LCM(void)
{	write_inst(0x30); 			// ]w\-8줸-򥻫O 
	write_inst(0x30); 			// ]w\-8줸-򥻫O 
	write_inst(0x08); 			// ܥ\-ܹ-L-Ф{ 
	write_inst(0x01); 			// Mܹ(0x20,I/D=1)
	write_inst(0x06); 			// JҦ-}W-ܹ 
	write_inst(0x0C); 			// ܥ\-}ܹ-L-Ф{ 
}			  					// init_LCM()Ƶ 
// ======= LCM.h  ===============================