import socket

# Define the listening address and port
local_address = ('0.0.0.0', 12345)

# Create a UDP socket
udp_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)

# Bind the socket to the address and port
udp_socket.bind(local_address)

print(f"Listening for UDP messages on {local_address}")

while True:
    # Receive data from sender
    data, sender_address = udp_socket.recvfrom(1024)  # Buffer size of 1024 bytes
    print(f"Received message from {sender_address}: {data.decode()}")