#include <8051.h> // Defining SFRs
#include "uart.c"

// ISR Prototypes ===================================================
void INT0_ISR(void) __interrupt (0); // ISR for External Interrupt 0
void T0_ISR(void)   __interrupt (1); // ISR for Timer0/Counter0 Overflow Interrupt
void INT1_ISR(void) __interrupt (2); // ISR for External Interrupt 1
void T1_ISR(void)   __interrupt (3); // ISR for Timer1/Counter1 Overflow Interrupt
void UART_ISR(void) __interrupt (4); // ISR for UART Interrupt

void main(void)
{
uart_initialize();
uart_put_char(0xA9);uart_put_char(0xE1); // Command Header
uart_put_char(0x04); // Baud Rate: 1=1200,2=2400,3=4800,4=9600,5=19200,6=38400
uart_put_char(0x00); // Channel: 0~127
uart_put_char(0x09); // Power: 0=-35dB,1=-25dB,2=-15dB,3=-5dB,4=0dB,5=+3dB,6=+6dB,7=+9dB,8=+10dB,9=+12dB
uart_put_char(0xA0); // UART Mode
uart_put_char(0x00);uart_put_char(0x00);uart_put_char(0x00);uart_put_char(0x00); // 32-bit Pairing ID; Send and Receiver MUST have the same ID
uart_put_char(0x00); // Echo: 0=No Echo,1=Echo
uart_put_char(0x00); // N/A
uart_put_char(0x0D); uart_put_char(0x0A); // Commend End
}

void INT0_ISR(void) __interrupt (0)
{}
void T0_ISR(void) __interrupt (1)
{}
void INT1_ISR(void) __interrupt (2)
{}
void T1_ISR(void) __interrupt (3)
{}
void UART_ISR(void) __interrupt (4)
{}