; Demonstration of External Interrupt
; Chin-Shiuh Shieh
; 2007-10-24
;
; Pin Assignment
LED_PORT	EQU		P2
DC_MOTOR	EQU		P0.0
; Memory Allocation
LED_DATA	EQU		30h		; Byte for LED Data
DIRECTION	EQU		00h		; Bit for shift direction, 0 for left, 1 for right
;
PROG	EQU		0000h
		ORG		PROG+0000h
		SJMP	START
;Interrupt Vector Table
		ORG		PROG+0003h
		LCALL	INT0_ISR
		RETI
		ORG		PROG+000Bh
		LCALL	T0_ISR
		RETI
		ORG		PROG+0013h
		LCALL	INT1_ISR
		RETI
		ORG		PROG+001Bh
		LCALL	T1_ISR
		RETI
		ORG		PROG+0023h
		LCALL	UART_ISR
		RETI
;
		ORG		PROG+0030h
START:
		MOV		LED_DATA,#01h
		CLR		DIRECTION
		SETB	IT0		; Set External Interrupt 0 to be falling edge triggered
		SETB	EX0		; Enable External Interrut 0
		SETB	EA		; Enable Interrupt
LOOP:
		MOV		A,LED_DATA
		JB		DIRECTION,SHIFT_RIGHT
SHIFT_LEFT:
		RL		A
		SJMP	SAVE_DATA
SHIFT_RIGHT:
		RR		A
SAVE_DATA:
		MOV		LED_DATA,A
		CPL		A
		MOV		LED_PORT,A
		CALL	DELAY
		CPL		A
CHECK_LEFT_BOUND:
		CJNE	A,#10000000b,CHECK_RIGHT_BOUND
		SETB	DIRECTION
CHECK_RIGHT_BOUND:
		CJNE	A,#00000001b,DONE
		CLR		DIRECTION
DONE:
		SJMP	LOOP
;
INT0_ISR:
		CLR		DC_MOTOR
		MOV		R2,#40h
WAIT:	CALL	DELAY
		DJNZ	R2,WAIT
		SETB	DC_MOTOR
		RET
T0_ISR:
		RET
INT1_ISR:
		RET
T1_ISR:
		RET
UART_ISR:
		RET
;Delay
DELAY:	MOV		R0,#80h
DELAY0:	MOV		R1,#00h
DELAY1:	DJNZ	R1,DELAY1
		DJNZ	R0,DELAY0
		RET
;
		END