// AT89C51/52 Programmer
// Chin-Shiuh Shieh
// 2003-09-21
// Raisonance RIDE 51 V6.16

#include <AT89C51.h>

#define High_Addr_Port	P2
#define Low_Addr_Port	P1
#define Data_Port			P0
#define Mode26				P3_4
#define Mode27				P3_5
#define Mode36				P3_6
#define Mode37				P3_7
#define PROG				P2_7
#define VPPC				P3_3
#define RDY					P3_2

#define Wait_Start		0
#define Wait_High_Addr	1
#define Wait_Low_Addr	2
#define Wait_Data			3

unsigned char state;
unsigned char High_Addr, Low_Addr, Data;

void UART_ISR(void) interrupt 4
{
int i;
if(TI==1)
	{
	TI=0;
	}
if(RI==1)
	{
	switch(state)
		{
		case Wait_Start:
			// Erase Chip
			Mode26=1;Mode27=0;Mode36=0;Mode37=0;	// Erase Chip Mode
			asm {0x00,0x00,0x00,0x00,0x00};			// Insert 5 NOP for t_EHSH 
			VPPC=0;											// EA/VPP=12V
			for(i=-32768;i<32767;i++);					// Wait for VPP Rising Up to 12V
			asm {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};	// Insert 12 NOP for t_SHGL
			PROG=0;
			for(i=0;i<886;i++);							// Delay for 10mS
			PROG=1;
			asm {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};	// Insert 12 NOP for t_GHSL
			VPPC=1;											// EA/VPP=5V
			for(i=-32768;i<32767;i++);					// Wait for VPP Falling Down to 5V
			Mode26=0;Mode27=1;Mode36=1;Mode37=1;	// Write Code Mode
			asm {0x00,0x00,0x00,0x00,0x00};			// Insert 5 NOP for t_EHSH
			VPPC=0;											// EA/VPP=12V
			for(i=-32768;i<32767;i++);					// Wait for VPP Rising Up to 12V
			state=Wait_High_Addr;
			break;
		case Wait_High_Addr:
			High_Addr=SBUF;
			state=Wait_Low_Addr;
			break;
		case Wait_Low_Addr:
			Low_Addr=SBUF;
			state=Wait_Data;
			break;
		case Wait_Data:
			Data=SBUF;
			High_Addr_Port=High_Addr|0xC0;
			Low_Addr_Port=Low_Addr;
			Data_Port=Data;
			asm {0x00,0x00,0x00,0x00,0x00};			// Insert 5 NOP for t_AVGL and t_DVGL
			PROG=0;
			asm {0x00};										// Insert 1 NOP for t_GLGH
			PROG=1;
			asm {0x00,0x00,0x00,0x00,0x00};			// Insert 5 NOP for t_GHDX, t_GHAX, and t_GHBL
			while(!RDY);									// Wait for Ready
			state=Wait_High_Addr;
			break;
		}
	SBUF=SBUF;
	RI=0;
	}
}

void main(void)
{
int i;
for(i=0;i<886;i++);
// Set Baud Rate to 9600 bps
PCON=0x80;	// Double BAUD Rate
TMOD=0x21;	// Set Timer 1 to Mode 2, Timer 0 to Mode 1
TH1=0xFF;	// Set BAUD Rate to 57600 bps
SCON=0x50;	// Set Serial Port to 8-bit UART
ES=1;			// Enable Serial Port Interrupt
EA=1;			// Enable Interrupt
TR1=1;		// Start Timer 1
// Wait for Downlaod
state=Wait_Start;
while(1);
} 

