// AT89C51/52 Programmer
// Chin-Shiuh Shieh
// 2003-09-21
// Borland C++ Builder 5.0
//---------------------------------------------------------------------------
#include <stdio.h>
#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CPort"
#pragma resource "*.dfm"

#define FLASH_SIZE 8192

typedef enum {
        Wait_Request_For_High_Address,
        Wait_Request_For_Low_Address,
        Wait_Request_For_Data,
        Wait_For_ACK } Status;

Status          state;
unsigned char   flash_buffer[FLASH_SIZE];
bool            tag[FLASH_SIZE];
int             address;
int             byte_count;

// hexidecimal to decimal conversion
int h2d(char c)
{
if('9'>=c && c>='0')
        return(c-'0');
if('Z'>=c && c>='A')
        return(c-'A'+10);
if('z'>=c && c>='a')
        return(c-'a'+10);
return(0);
}

TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
ComPort1->Open();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
ComPort1->Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
FILE*   file_ptr;
char    line[256];
int     i,addr,data;

for(i=0;i<FLASH_SIZE;i++)
        {
        flash_buffer[i]=0xFF;
        tag[i]=false;
        }

OpenDialog1->Execute();
Edit1->Text=OpenDialog1->FileName;
file_ptr=fopen(OpenDialog1->FileName.c_str(),"r");
while(!feof(file_ptr))
        {
        fgets(line,256,file_ptr);
        byte_count=(h2d(line[1])*16)+h2d(line[2]);
        addr=(((h2d(line[3])*16)+h2d(line[4]))*16+h2d(line[5]))*16+h2d(line[6]);
        for(i=0;i<byte_count;i++)
                {
                data=(h2d(line[10+i*2-1])*16)+h2d(line[10+i*2]);
                flash_buffer[addr+i]=data;
                tag[addr+i]=true;
                }
        }
fclose(file_ptr);

byte_count=0;
for(i=0;i<FLASH_SIZE;i++)
        if(tag[i]==true)
                byte_count++;
ProgressBar1->Max=byte_count;
StatusBar1->SimpleText=IntToStr(byte_count)+" bytes.";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
unsigned char com_buffer[1];

com_buffer[0]=0;
state=Wait_Request_For_High_Address;
address=0;byte_count=ProgressBar1->Max;
StatusBar1->SimpleText="Erasing ...";
ComPort1->Write(com_buffer,1);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ComPort1RxChar(TObject *Sender, int Count)
{
unsigned char com_buffer[1];

ComPort1->Read(com_buffer,1);
switch(state)
        {
        case Wait_Request_For_High_Address:
                while(tag[address]==false && address<FLASH_SIZE)
                        address++;
                com_buffer[0]=address/256;
                state=Wait_Request_For_Low_Address;
                ComPort1->Write(com_buffer,1);
                break;
        case Wait_Request_For_Low_Address:
                com_buffer[0]=address%256;
                state=Wait_Request_For_Data;
                ComPort1->Write(com_buffer,1);
                break;
        case Wait_Request_For_Data:
                com_buffer[0]=flash_buffer[address];
                address++;byte_count--;
                if(byte_count>0)
                        state=Wait_Request_For_High_Address;
                else
                        state=Wait_For_ACK;
                ProgressBar1->Position=ProgressBar1->Max-byte_count;
                StatusBar1->SimpleText="Programming ...";
                ComPort1->Write(com_buffer,1);
                break;
        case Wait_For_ACK:
                StatusBar1->SimpleText="Programming Complete!";
                break;
        }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RadioButton1Click(TObject *Sender)
{
ComPort1->Close();
ComPort1->Port="COM1";
ComPort1->Open();
StatusBar1->SimpleText="57600 bps at COM1";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RadioButton2Click(TObject *Sender)
{
ComPort1->Close();
ComPort1->Port="COM2";
ComPort1->Open();
StatusBar1->SimpleText="57600 bps at COM2";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RadioButton3Click(TObject *Sender)
{
ComPort1->Close();
ComPort1->Port="COM3";
ComPort1->Open();
StatusBar1->SimpleText="57600 bps at COM3";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RadioButton4Click(TObject *Sender)
{
ComPort1->Close();
ComPort1->Port="COM4";
ComPort1->Open();
StatusBar1->SimpleText="57600 bps at COM4";
}
//---------------------------------------------------------------------------

