// EEPROM W27C257 Programmer
// Chin-Shiuh Shieh
// 2003-06-04

#include <AT89C51.h>

#define PAGE_SIZE			64

#define Low_Addr_Port	P0
#define High_Addr_Port	P2
#define Data_Port			P1
#define EEPROM_VPP_C0	P3_2
#define EEPROM_VPP_C1	P3_3
#define EEPROM_A9_C0		P3_4
#define EEPROM_A9_C1		P2_1
#define EEPROM_CE			P3_5
#define EEPROM_OE			P3_7

typedef enum {
	Wait_Start,
	Wait_Page_High_Addr,
	Wait_Page_Low_Addr,
	Wait_Data } Status;

unsigned char 	page_high_addr;
unsigned char 	page_low_addr;
unsigned char 	page_buffer[PAGE_SIZE];
unsigned char 	byte_index;
Status 			state;

void UART_ISR(void) interrupt 4
{
int i;
if(TI==1)
	{
	TI=0;
	}
if(RI==1)
	{
	switch(state)
		{
		case Wait_Start:
			state=Wait_Page_High_Addr;
			break;
		case Wait_Page_High_Addr:
			page_high_addr=SBUF;
			state=Wait_Page_Low_Addr;
			break;
		case Wait_Page_Low_Addr:
			page_low_addr=SBUF;
			state=Wait_Data;
			byte_index=0;
			break;
		case Wait_Data:
			page_buffer[byte_index]=SBUF;
			byte_index++;
			if(byte_index==PAGE_SIZE)
				{
				// Write Page
				for(byte_index=0;byte_index<PAGE_SIZE;byte_index++)
					{
					High_Addr_Port=page_high_addr;
					Low_Addr_Port=page_low_addr;
					Data_Port=page_buffer[byte_index];
					EEPROM_VPP_C0=0;EEPROM_VPP_C1=1;	// Vpp=12V
					EEPROM_CE=0;
					for(i=0;i<45;i++); // Delay for more than 100uS
					EEPROM_CE=1;
					EEPROM_VPP_C0=1;EEPROM_VPP_C1=1;	// Vpp=5V
					page_low_addr++;
					if(page_low_addr==0)
						page_high_addr++;
					}
				state=Wait_Start;
				}
			break;
		}
	SBUF=SBUF;
	RI=0;
	}
}

void main(void)
{
int i;
// Set Baud Rate to 9600 bps
TMOD=0x21;
TH1=0xFD;
SCON=0x50;
ES=1;
EA=1;
TR1=1;
// Initialize Control Pins
EEPROM_VPP_C0=1;EEPROM_VPP_C1=1;	// Vpp=5V
EEPROM_A9_C0=1;EEPROM_A9_C1=1;	// A9=5V
EEPROM_CE=1;
EEPROM_OE=1;
// Erase EEPROM
EEPROM_VPP_C0=0;EEPROM_VPP_C1=0;	// Vpp=14V
Low_Addr_Port=0;
High_Addr_Port=0;
Data_Port=0xFF;
EEPROM_A9_C0=0;EEPROM_A9_C1=1;	// A9=14V
EEPROM_CE=0;
for(i=-32768;i<13000;i++); 		// Delay for 100mS
EEPROM_CE=1;
EEPROM_A9_C0=1;EEPROM_A9_C1=1;	// A9=5V
EEPROM_VPP_C0=1;EEPROM_VPP_C1=1;	// Vpp=5V
// Set Initial State
state=Wait_Start;
while(1);
}
 
