// EEPROM W27C257 Programmer
// Chin-Shiuh Shieh
// 2003-06-04
//---------------------------------------------------------------------------
#include <stdio.h>
#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#define EEPROM_SIZE 32768
#define PAGE_SIZE 64
#define NUMBER_OF_PAGE (EEPROM_SIZE/PAGE_SIZE)

typedef enum {
        Wait_Request_For_Page_High_Address,
        Wait_Request_For_Page_Low_Address,
        Wait_Request_For_Data,
        Wait_For_ACK } Status;

unsigned char   eeprom_buffer[EEPROM_SIZE];
bool            page_tag[NUMBER_OF_PAGE];
int             page_count;
int             page_index;
int             byte_index;
Status          state;

// hexidecimal to decimal conversion
int h2d(char c)
{
if('9'>=c && c>='0')
        return(c-'0');
if('Z'>=c && c>='A')
        return(c-'A'+10);
if('z'>=c && c>='a')
        return(c-'a'+10);
return(0);
}

TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
ComPort1->Open();        
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
ComPort1->Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
FILE*   file_ptr;
char    line[256];
int     i,byte_count,addr,data;

for(i=0;i<EEPROM_SIZE;i++)
        eeprom_buffer[i]=0xFF;

OpenDialog1->Execute();
Edit1->Text=OpenDialog1->FileName;
file_ptr=fopen(OpenDialog1->FileName.c_str(),"r");
while(!feof(file_ptr))
        {
        fgets(line,256,file_ptr);
        byte_count=(h2d(line[1])*16)+h2d(line[2]);
        addr=(((h2d(line[3])*16)+h2d(line[4]))*16+h2d(line[5]))*16+h2d(line[6]);
        for(i=0;i<byte_count;i++)
                {
                data=(h2d(line[10+i*2-1])*16)+h2d(line[10+i*2]);
                eeprom_buffer[addr+i]=data;
                page_tag[(addr+i)/PAGE_SIZE]=true;
                }
        }
fclose(file_ptr);

page_count=0;
for(i=0;i<NUMBER_OF_PAGE;i++)
        if(page_tag[i]==true)
                page_count++;
ProgressBar1->Max=page_count;
StatusBar1->SimpleText=IntToStr(page_count)+" pages.";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
unsigned char com_buffer[1];

com_buffer[0]=0;
state=Wait_Request_For_Page_High_Address;
page_index=0;
ComPort1->Write(com_buffer,1);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ComPort1RxChar(TObject *Sender, int Count)
{
unsigned char com_buffer[1];
int page_address;

ComPort1->Read(com_buffer,1);
switch(state)
        {
        case Wait_Request_For_Page_High_Address:
                while(page_tag[page_index]==false && page_index<NUMBER_OF_PAGE)
                        page_index++;
                page_address=page_index*PAGE_SIZE;
                com_buffer[0]=page_address/256;
                state=Wait_Request_For_Page_Low_Address;
                ComPort1->Write(com_buffer,1);
                break;
        case Wait_Request_For_Page_Low_Address:
                page_address=page_index*PAGE_SIZE;
                com_buffer[0]=page_address%256;
                state=Wait_Request_For_Data;
                byte_index=0;
                ComPort1->Write(com_buffer,1);
                break;
        case Wait_Request_For_Data:
                page_address=page_index*PAGE_SIZE;
                com_buffer[0]=eeprom_buffer[page_address+byte_index];
                byte_index++;
                if(byte_index==PAGE_SIZE)
                        state=Wait_For_ACK;
                ComPort1->Write(com_buffer,1);
                break;
        case Wait_For_ACK:
                page_count--;
                ProgressBar1->Position=ProgressBar1->Max-page_count;
                if(page_count>0)
                        {
                        com_buffer[0]=0;
                        state=Wait_Request_For_Page_High_Address;
                        page_index++;
                        ComPort1->Write(com_buffer,1);
                        }
                else
                        StatusBar1->SimpleText="Programming Complete!";
                break;
        }
}
//---------------------------------------------------------------------------
