#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MG 50		/* Maximal Number of Generations */
#define N  10		/* Population Size */
#define CL 32		/* Number of bits in each chromosome */
#define SF 2.0		/* Selection Factor */
#define CR 0.5		/* Crossover Rate */
#define MR 0.05		/* Mutation Rate */

/* Macro for random number between 0 and 1 */
#define RAND ((float)rand()/(float)(RAND_MAX+1)) 

int   c[N][CL];		/* Population of Chromosomes */
float f[N];			/* Fitness Value of Chromosomes */
int   best_c[CL];	/* Best Chromosome */
float best_f;		/* Best Fitness Value */

/* Decode Chromosome */
void decode(int chromosome[CL],float *x,float *y)
{
int j;
/* Decode the lower 16 bits for variable x */
(*x)=0.0;
for(j=0;j<CL/2;j++)
	(*x)=(*x)*2.0+chromosome[j];
(*x)=(*x)/pow(2.0,16.0)*10.0-5.0;
/* Decode the upper 16 bits for variable y */
(*y)=0.0;
for(j=CL/2;j<CL;j++)
	(*y)=(*y)*2.0+chromosome[j];
(*y)=(*y)/pow(2.0,16.0)*10.0-5.0;
}

/* Object Function */
float object(float x,float y)
{
return(4.0/((x-2.0)*(x-2.0)+(y-2.0)*(y-2.0)+1.0)+3.0/((x-2.0)*(x-2.0)+(y+2.0)*(y+2.0)+1.0)+2.0/((x+2.0)*(x+2.0)+(y-2.0)*(y-2.0)+1.0));
}

void main(void)
{
int     i,k;		/* Index for Chromosome */
int     j;      	/* Index for Generation */
int     gen;    	/* Index for Generation */
float   x,y;    	/* Independent Variables */
int     site;   	/* Mutation Site */
float   tmpf;
int     tmpi;
int     tmpc[N][CL];/* Temporary Population */
float   p[N];		/* Selection Probability */

/* Set random seed */
srand(4);

/* Initialize Population */
best_f=-1.0e99;
for(i=0;i<N;i++)
	{
	/* Randomly set each gene to '0' or '1' */
	for(j=0;j<CL;j++)
		if(RAND<0.5)
			c[i][j]=0;
		else
			c[i][j]=1;
	}

/* Repeat Genetic Algorithm cycle for MG times */
for(gen=0;gen<MG;gen++)
	{
	/* Evaluation */
	for(i=0;i<N;i++)
		{
		decode(c[i],&x,&y);
		f[i]=object(x,y);
		/* Update best solution */
		if(f[i]>best_f)
			{
			best_f=f[i];
			for(j=0;j<CL;j++)
				best_c[j]=c[i][j];
			}
		}
	/* Selection */
	/* Evaluate Selection Probability */
	tmpf=0.0;
	for(i=0;i<N;i++)
		{
		p[i]=pow(f[i],SF);
		tmpf=tmpf+p[i];
		}
	for(i=0;i<N;i++)
		p[i]=p[i]/tmpf;
	/* Retain the best Chromosome found so far */
	for(j=0;j<CL;j++)
		tmpc[0][j]=best_c[j];
	/* Roulette wheel selection with replacement */
	for(i=1;i<N;i++)
		{
		tmpf=RAND;
		for(k=0;tmpf>p[k];k++)
			tmpf=tmpf-p[k];
		/* Chromosome k is selected */
		for(j=0;j<CL;j++)
			tmpc[i][j]=c[k][j];
		}
	/* Copy temporary population to population */
	for(i=0;i<N;i++)
		for(j=0;j<CL;j++)
			c[i][j]=tmpc[i][j];
	/* 1-site Crossover */
	for(i=0;i<N;i=i+2)
		if(RAND<CR)
			{
			site=RAND*CL;
			for(j=0;j<site;j++)
				{
				tmpi=c[i][j];
				c[i][j]=c[i+1][j];
				c[i+1][j]=tmpi;
				}
			}
	/* Mutation */
	for(i=0;i<N;i++)
		for(j=0;j<CL;j++)
			if(RAND<MR)
			c[i][j]=1-c[i][j];	/* Flip j-th gene */
	/* Report Progress */
	printf("%f\n",best_f);
	}
/* Report Solution */
decode(best_c,&x,&y);
printf("F(%f,%f)=%f\n",x,y,object(x,y));
}
