#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define IterationLimit  1000    /* Maximal Number of Iteration */
#define PopulationSize  40      /* Population Size: Number of Particles */
#define Dimension       2       /* Dimension of Search Space */
#define wU              0.9     /* Upper Bound of Inertia Weight */
#define wL              0.4     /* Lower Bound of Inertia Weight */
#define c1              2.0     /* Acceleration Factor 1 */
#define c2              2.0     /* Acceleration Factor 2 */
#define Vmax            1000.0  /* Maximal Velocity */
#define RAND            ((float)rand()/(float)(RAND_MAX+1))

typedef struct {
        float x[Dimension];             /* Position */
        float v[Dimension];             /* Velocity */
        float fitness;                  /* Fitness */
        float best_x[Dimension];        /* Individual Best Solution */
        float best_fitness;             /* Individual Best Fitness */
        } ParticleType;

ParticleType    p[PopulationSize];      /* Particle Array */
float           gbest_x[Dimension];     /* Global Best Solution */
float           gbest_fitness;          /* Global Best Fitness */

/* Schwefel Function */
float Schwefel(float x[Dimension])
{
int i;
float tmp;
tmp=0.0;
for(i=0;i<Dimension;i++)
        tmp+=(-1.0)*x[i]*sin(sqrt(fabs(x[i])));
return(tmp);
}

void main(void)
{
int     i;      /* Index for Particle */
int     d;      /* Index for Dimension */
float   w;      /* Inertia Weight */
int     step;   /* Index for PSO cycle */

/* Set random seed */
srand(1);

/* Initialize particles */
gbest_fitness=-1.0e99;
for(i=0;i<PopulationSize;i++)
        {
        for(d=0;d<Dimension;d++)
                {
                p[i].x[d]=p[i].best_x[d]=RAND*1000.0-500.0;
                p[i].v[d]=RAND*1000.0-500.0;
                }
        p[i].fitness=p[i].best_fitness=Schwefel(p[i].x);
        /* Update gbest */
        if(p[i].best_fitness>gbest_fitness)
                {
                for(d=0;d<Dimension;d++)
                        gbest_x[d]=p[i].best_x[d];
                gbest_fitness=p[i].best_fitness;
                }
        }

/* Repeat PSO cycle for InterationLimit times */
for(step=0;step<IterationLimit;step++)
        {
        w=wU-(wU-wL)*((float)step/(float)IterationLimit);
        for(i=0;i<PopulationSize;i++)
                {
                for(d=0;d<Dimension;d++)
                        {
                        p[i].v[d]=w*p[i].v[d]+c1*RAND*(p[i].best_x[d]-p[i].x[d])+c2*RAND*(gbest_x[d]-p[i].x[d]);
                        if(p[i].v[d]>Vmax)p[i].v[d]=Vmax;
                        if(p[i].v[d]<-Vmax)p[i].v[d]=-Vmax;
                        p[i].x[d]=p[i].x[d]+p[i].v[d];
                        if(p[i].x[d]>500.0)p[i].x[d]=500.0;
                        if(p[i].x[d]<-500.0)p[i].x[d]=-500.0;                        }
                p[i].fitness=Schwefel(p[i].x);
                /* Update pbest */
                if(p[i].fitness>p[i].best_fitness)
                        {
                        for(d=0;d<Dimension;d++)
                                p[i].best_x[d]=p[i].x[d];
                        p[i].best_fitness=p[i].fitness;
                        /* Update gbest */
                        if(p[i].best_fitness>gbest_fitness)
                                {
                                for(d=0;d<Dimension;d++)
                                        gbest_x[d]=p[i].best_x[d];
                                gbest_fitness=p[i].best_fitness;
                                }
                        }
                }
        printf("%f\n",gbest_fitness);
        }
}

