// Winsock UDP Message Receiver
// Chin-Shiuh Shieh
// 2002-04-03
#include <winsock2.h>
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
SOCKET Socket;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
WORD RequiredVersion=0x0002;
WSADATA WSAData;
int WSAStartupErrorCode;

if((WSAStartupErrorCode=WSAStartup(RequiredVersion,&WSAData))==0)
    StatusBar1->SimpleText="Winsock is started!";
else
    StatusBar1->SimpleText="WSAStartup Error "+IntToStr(WSAStartupErrorCode)+"!";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
if(WSACleanup()==SOCKET_ERROR)
    StatusBar1->SimpleText="WSACleanup Error "+IntToStr(WSAGetLastError())+"!";
else
    StatusBar1->SimpleText="Winsock is stopped!";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
char HostName[256];
hostent* HostInfo;
sockaddr_in LocalSockAddr;

if(gethostname(HostName,sizeof(HostName))==SOCKET_ERROR)
    {
    StatusBar1->SimpleText="gethostname Error "+IntToStr(WSAGetLastError())+"!";
    return;
    }
if((HostInfo=gethostbyname(HostName))==NULL)
    {
    StatusBar1->SimpleText="gethostbyname Error "+IntToStr(WSAGetLastError())+"!";
    return;
    }
Label5->Caption=StrPas(HostInfo->h_name);
Label6->Caption="("+StrPas(inet_ntoa(*(in_addr*)(void*)HostInfo->h_addr_list[0]))+")";

if((Socket=socket(AF_INET,SOCK_DGRAM,0))==INVALID_SOCKET)
    {
    StatusBar1->SimpleText="socket Error "+IntToStr(WSAGetLastError())+"!";
    return;
    }

LocalSockAddr.sin_family=AF_INET;
LocalSockAddr.sin_port=htons(StrToInt(Edit1->Text));
LocalSockAddr.sin_addr=*(in_addr*)(void*)HostInfo->h_addr_list[0];
if(bind(Socket,(sockaddr*)&LocalSockAddr,sizeof(sockaddr_in))==SOCKET_ERROR)
    {
    StatusBar1->SimpleText="bind Error "+IntToStr(WSAGetLastError())+"!";
    return;
    };

if(WSAAsyncSelect(Socket,Button3->Handle,0x202,FD_READ)==SOCKET_ERROR)
    {
    StatusBar1->SimpleText="WSAAsyncSelect Error "+IntToStr(WSAGetLastError())+"!";
    return;
    }
else
    {
    Edit2->Text="";
    Edit3->Text="";
    StatusBar1->SimpleText="Waiting for incoming message ...";
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
if(closesocket(Socket)==SOCKET_ERROR)
    {
    StatusBar1->SimpleText="closesocket Error "+IntToStr(WSAGetLastError())+"!";
    return;
    }
else
    StatusBar1->SimpleText="Stopped!";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button3MouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
sockaddr_in RemoteSockAddr;
char buffer[256];
int len,sockaddr_in_len;

RemoteSockAddr.sin_family=AF_INET;
sockaddr_in_len=sizeof(sockaddr_in);
if((len=recvfrom(Socket,buffer,sizeof(buffer),0,(sockaddr*)&RemoteSockAddr,&sockaddr_in_len))==SOCKET_ERROR)
    {
    StatusBar1->SimpleText="recvfrom Error "+IntToStr(WSAGetLastError())+"!";
    return;
    }
else
    {
    buffer[len]=0;
    Edit2->Text=StrPas(buffer);
    Edit3->Text=StrPas(inet_ntoa(RemoteSockAddr.sin_addr));
    StatusBar1->SimpleText=IntToStr(len)+" bytes received!";
    }
}
//---------------------------------------------------------------------------

